#!/usr/bin/awk -f

#USAGE: mocc_to_mprot.awk sites_file mocc_file(s)

#This script splits the info in the .mocc files (mean occupancies), writing
#a file for each titrating site. It needs to read a .sites file to make the
#assignment of the mean protonations to the sites. A file with the total
#mean protonation is also written.

BEGIN{

    usage = "Usage: mocc_to_mprot.awk sites_file mocc_file(s)"
    if (ARGC < 3) {
	print "Wrong number of arguments.\n" usage > "/dev/stderr"
	exit 1
    } 
    
    #Read sites
    sites_file=ARGV[1]
    i=0
    t=0
    while (getline < sites_file) {
	#Assign site name to index
	name[++i]=substr($2,1,index($2,"t")-1) "-" $1
    }
    close(sites_file)
    
}

#Read the occ file(s)
NR>FNR{    
    ++t
    #Assign mean protonation to index
    for (i=1; i<=NF; i++) prot[t,i] = $i ;
}

END{
    n=t
    for (s in name)
    {
	#Write file for each site with frame and protonation
	printf "#Cycle and Protonation of %s\n", name[s]  > name[s] ".mprot"
	for (t=1; t<=n; t++) 
	    printf "%d %f\n", t, prot[t,s] > name[s] ".mprot"
    }

    #Write file with frame and total protonation
    printf "#Cycle and Total Protonation\n"  > "total.mprot"
    for (t=1; t<=n; t++)
    {
      sum = 0 ;
      for (s in name) sum += prot[t,s] ;
      printf "%d %f\n", t, sum > "total.mprot"
    }
}

