#!/bin/bash -e

gmxbin=$1

#T=300 K
#I=0.1 M
ncpus=4     # change if needed


# Step 1: restraints on all non-hydrogens, NVT, 50 ps

$gmxbin/gmx grompp \
    -f md_i50.mdp -po md_i50_out.mdp -c min2.gro -p lysoX-r.top \
    -o i50.tpr -pp ppi50.top -r min2.gro \
    -maxwarn 4 &> g-i50.err

$gmxbin/gmx mdrun -nt $ncpus \
    -s i50.tpr -x i50.xtc -c i50.gro -e i50.edr \
    -g i50.log -nice 19 &> i50.err


# Step 2: restraints on CA, NVT, 50 ps

$gmxbin/gmx grompp \
    -f md_i100.mdp -po md_i100_out.mdp -c i50.gro -p lysoX-r.top \
    -o i100.tpr -pp ppi100.top -r i50.gro \
    -maxwarn 4 &> g-i100.err

$gmxbin/gmx mdrun -nt $ncpus \
    -s i100.tpr -x i100.xtc -c i100.gro -e i100.edr \
    -g i100.log -nice 19 &> i100.err


# Step 3: restraints on CA, NPT, 100 ps

$gmxbin/gmx grompp \
    -f md_i200.mdp -po md_i200_out.mdp -c i100.gro -p lysoX-r.top \
    -o i200.tpr -pp ppi200.top -r i100.gro \
    -maxwarn 4 &> g-i200.err

$gmxbin/gmx mdrun -nt $ncpus\
    -s i200.tpr -x i200.xtc -c i200.gro -e i200.edr \
    -g i200.log -nice 19 &> i200.err

