#!/bin/bash -e 

gmxbin=$1

# Energy minimization

# Step 1: restraints on all non-hydrogens

$gmxbin/gmx grompp \
    -f min1.mdp -po min1_out.mdp -c lysoX.gro -p lysoX.top \
    -pp min1-pp.top -o min1.tpr -r lysoX.gro \
    -maxwarn 1000 &> gmin1.err

$gmxbin/gmx mdrun \
    -s min1.tpr -x min1.xtc -c min1.gro \
    -e min1.edr -g min1.log -v &> min1.err


# Step 2: no restraints

$gmxbin/gmx grompp \
    -f min2.mdp -po min2_out.mdp -c min1.gro -p lysoX.top \
    -pp min2-pp.top -o min2.tpr -r min1.gro \
    -maxwarn 1000 &> gmin2.err

$gmxbin/gmx mdrun \
    -s min2.tpr -x min2.xtc -c min2.gro \
    -e min2.edr -g min2.log -v &> min2.err

