/*
This file is part of grms_to_central, version 1.0.

Copyright (c) 2006-2019, Instituto de Tecnologia Quimica e Biologica,
Universidade Nova de Lisboa, Portugal.

grms_to_central is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 2 of the License, or (at your
option) any later version.

grms_to_central is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with grms_to_central.  If not, see <http://www.gnu.org/licenses/>.

For further details and info check the README file.

You can get grms_to_central at www.itqb.unl.pt/simulation
*/


/*

USAGE: grms_to_central tel_mat tel_mat2 input_bin run_name

See README for details.

*/

#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>

#ifdef GMX_DOUBLE
typedef double          real;
#else
typedef float           real;
#endif

#define MAXSTRING 100

int main(int argc, char *argv[])
{
  int tel_mat, tel_mat2, i, j, central, n=0 ;  
  FILE *fp_bin , *fp_out, *fp_var ;
  real rmsd, var, min=10000000.0 ;
  char cp_command[MAXSTRING], f1name[MAXSTRING], f2name[MAXSTRING] ; 
 
  if (argc != 5)
    {
      fprintf(stderr, "Wrong number of arguments.\n") ;
      fprintf(stderr,
	      "USAGE: grms_to_central tel_mat tel_mat2 input_bin run_name\n") ;
      exit(1) ;
    }
  
  /*Read arguments*/
  tel_mat = atoi(argv[1]) ;
  tel_mat2 = atoi(argv[2]) ;

  if ( (fp_bin = fopen(argv[3], "rb")) == NULL ) 
    {
      fprintf(stderr, "ERROR! No such file %s.\n", argv[3]); 
      exit(1); 
    }

  /*Backup argv[4] if it already exists*/
  strcpy(f1name, argv[4]) ;
  if ( (fp_out = fopen(strcat(f1name,".xvg"), "r")) != NULL )
    {
      sprintf(cp_command, "cp %s \\#%s\\#", f1name, f1name) ; 
      if ( system(cp_command) )
	fprintf(stderr, "WARNING! Error in %s backup copy.\n", f1name);
    } 
  fp_out = fopen(f1name, "w");

  strcpy(f2name, argv[4]) ;
  if ( (fp_var = fopen(strcat(f2name,".var"), "r")) != NULL )
    {
      sprintf(cp_command, "cp %s \\#%s\\#", f2name, f2name) ; 
      if ( system(cp_command) )
	fprintf(stderr, "WARNING! Error in %s backup copy.\n", f2name);
    } 
  fp_var = fopen(f2name, "w");

  /*Read binary and write ascii*/
  /*At the same time, calculate variances and central structure
    according to Campos_2009_JPCB_113_15989.pdf*/
  for (j = 0 ; j < tel_mat ; j++)
    {
      var = 0 ;
      for (i = 0 ; i < tel_mat2 ; i++)
	{
	  if ( fread(&rmsd,sizeof(real),1,fp_bin) != 1)
	    {
	      fprintf(stderr,
		      "ERROR! Reading binary. Check tel_mat and tel_mat2!\n") ;
	      exit(1) ;
	    } 
	  fprintf(fp_out, "%d  %d  %g\n", j, i, rmsd) ;
	  var += (rmsd*rmsd) ;
	}
      var /= (tel_mat2 - 1) ;
      fprintf(fp_var, "%d  %g\n", j, var) ;
      if ( var < min ) { min = var ; central = j ; }
    }

  /*  fprintf(stdout, "Central: %d\n", central) ;*/
  fprintf(stdout, "%d\n", central) ;


  /*Check if there is data left in the binary.*/
  while ( fread(&rmsd,sizeof(real),1,fp_bin) == 1 ) n++ ;
  if (n)
    {
      fprintf(stderr, "ERROR! Check tel_mat and tel_mat2! Inconsistent with binary data size. %d number of sizeof real left.\n", n) ; 
      exit(1) ;
    }

  fclose(fp_bin) ;
  fclose(fp_out) ;
  fclose(fp_var) ;

  return 0;
}


