/*
This file is part of meadTools, version 2.2.

Copyright (c) 2001-2019, Instituto de Tecnologia Quimica e Biologica,
Universidade Nova de Lisboa, Portugal.

meadTools is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 2 of the License, or (at your
option) any later version.

meadTools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with meadTools.  If not, see <http://www.gnu.org/licenses/>.

For further details and info check the README file.

You can get meadTools at www.itqb.unl.pt/simulation
*/


/************************************************************************/
/* csplit:                                                              */
/*                                                                      */
/* c version of the split function of awk.                              */
/*                                                                      */
/* Function input/output:                                               */
/*                                                                      */
/* str:      input string to be split in words,                         */
/* dlm:      words delimiter,                                           */
/* maxln:    maximum number of strings (lines) of array words,          */
/* maxwrdsz: maximum size of the word strings (number of characters),   */
/* words:    array of strings with dimensions maxln,maxwrdsz            */
/*           to store the words of the split input string.              */
/*                                                                      */
/* The function returns the number of words found, the used dimension   */
/* of the array words.                                                  */
/*                                                                      */
/* Atention: new line characters are discarded!                         */
/*                                                                      */
/* Carlos A. Cunha, ITQB-UNL, Oeiras, Maro 2005                        */
/*                                                                      */
/* Acknowledgment: financial support from Fundacao para a Ciencia e a   */
/*                 Tecnologia, Portugal (grant SFRH/BPD/9466/2002).     */
/*                                                                      */
/************************************************************************/

#include<stdio.h>

int csplit(char *str, char *dlm, int maxln, int maxwrdsz, char *words) {

  char *aux, *aux_wrd, *wrd_bgin;

  int l=0, nc=0, i; 

  int first_dlm=1, before_first_wrd=1, first_chr=1;

  aux = str;

  while (*aux != '\0') {

    if (*aux == *dlm) {

      if (!first_chr) first_chr = 1;

      if ((first_dlm)&&(!before_first_wrd)) {*aux_wrd = '\0';}

      if (first_dlm)  first_dlm = 0;

    }

    else {

      if (before_first_wrd) {before_first_wrd = 0;}

      first_dlm = 1;

      if (first_chr) {

	++l;

	if (l > maxln) {
	  printf("\nWARNING: Dimensions of word array exceeded!\nExiting csplit...\n");
	  return maxln;
	}

	i = (l-1)*maxwrdsz;

	wrd_bgin = &words[i];
	aux_wrd = &words[i];
	nc = 0;
	first_chr = 0;
      }

      ++nc;

      if (nc < maxwrdsz) {

	if (*aux != '\n') {

	  *aux_wrd = *aux;
	  aux_wrd++; 
	}
	else --nc;
      }

      else if (nc == maxwrdsz) {

	*aux_wrd = '\0';

	printf("\nFound word *%s* larger than %d characters.\nIt will be truncated.\n", wrd_bgin, maxwrdsz);

      }

    }

    aux++;
  }

  *aux_wrd = '\0';

  return l;

}

