/*
This file is part of meadTools, version 2.2.

Copyright (c) 2001-2019, Instituto de Tecnologia Quimica e Biologica,
Universidade Nova de Lisboa, Portugal.

meadTools is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 2 of the License, or (at your
option) any later version.

meadTools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with meadTools.  If not, see <http://www.gnu.org/licenses/>.

For further details and info check the README file.

You can get meadTools at www.itqb.unl.pt/simulation
*/


/************************************************************************/
/* delsubstr:                                                           */
/*                                                                      */
/* This function deletes a substring from a given string.               */
/*                                                                      */
/* Function input/output:                                               */
/*                                                                      */
/* first: is the position in the string of the first character of the   */
/*        substring to be deleted,                                      */
/*                                                                      */
/* length: is the length of the substring to be deleted, not counting   */
/*         the null character at the end of the string .                */
/*                                                                      */
/* The function returns 0 in case an error occurs or the number of      */
/* characters moved at the end of the string if it runs successfully.   */
/*                                                                      */
/* Carlos A. Cunha, ITQB-UNL, Oeiras, Maro 2005                        */
/*                                                                      */
/* Acknowledgment: financial support from Fundacao para a Ciencia e a   */
/*                 Tecnologia, Portugal (grant SFRH/BPD/9466/2002).     */
/*                                                                      */
/************************************************************************/

#include<stdio.h>
#include<string.h>

int delsubstr(char *str, int first, int length) {

  int strl, last;

  int c, n=0;

  strl = strlen(str);

  if ((first + length) > (strl + 1)) {

    printf("\n*** Function delsubstr ERROR ***\nThe limit of substring to be deleted is out of the string limit!\n");

    return 0;
  }

  last = strl - length + 1;

  for (c=first; c<=last; c++) {

    str[c - 1] = str[c + length - 1];
    ++n;

  }

  return n;

}
