/*
This file is part of meadTools, version 2.2.

Copyright (c) 2001-2019, Instituto de Tecnologia Quimica e Biologica,
Universidade Nova de Lisboa, Portugal.

meadTools is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 2 of the License, or (at your
option) any later version.

meadTools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with meadTools.  If not, see <http://www.gnu.org/licenses/>.

For further details and info check the README file.

You can get meadTools at www.itqb.unl.pt/simulation
*/


/************************************************************************/
/* findigits:                                                           */
/*                                                                      */
/* This function tests if a given string contains any digits at a given */
/* position.                                                            */
/*                                                                      */
/* The function returns the number of digits found from the position in */
/* the string until the first non-digit character is found.             */
/* It returns -1 in case of error.                                      */
/*                                                                      */
/* Function input:                                                      */
/*                                                                      */
/* str: string,                                                         */
/* pstn : starting position to search for digits.                       */
/*                                                                      */
/* Carlos A. Cunha, ITQB-UNL, Oeiras, Maro 2005                        */
/*                                                                      */
/* Acknowledgment: financial support from Fundacao para a Ciencia e a   */
/*                 Tecnologia, Portugal (grant SFRH/BPD/9466/2002).     */
/*                                                                      */
/************************************************************************/

#include<stdio.h>
#include<ctype.h>
#include<string.h>

int findigits(char *str, int pstn) {

  char *aux;

  int lenstr;

  int i, nd=0;

  lenstr = strlen(str);

  if ((pstn>lenstr)||(pstn<=0)) {

    printf("\n*** Error in function findigits: ***\nPosition of string pointer out of string length!\n");

    return -1;
  }

  for (i = pstn-1 ; i<=lenstr-1 ; i++) {

    aux = &str[i];

    if (isdigit(aux[0])) ++nd;
    else break;

  }

  return nd;

}
