/*
This file is part of meadTools, version 2.2.

Copyright (c) 2001-2019, Instituto de Tecnologia Quimica e Biologica,
Universidade Nova de Lisboa, Portugal.

meadTools is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 2 of the License, or (at your
option) any later version.

meadTools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with meadTools.  If not, see <http://www.gnu.org/licenses/>.

For further details and info check the README file.

You can get meadTools at www.itqb.unl.pt/simulation
*/


/************************************************************************/
/* findsubstr:                                                          */
/*                                                                      */
/* This function tests if a given string contains a given substring.    */
/*                                                                      */
/* The function returns the position of the first character of the      */
/* substring in the string, 0 if the string is not found or -1 in case  */
/* of error.                                                            */
/*                                                                      */
/* Function input:                                                      */
/*                                                                      */
/* str: string,                                                         */
/* substr : substring to be found.                                      */
/*                                                                      */
/* Carlos A. Cunha, ITQB-UNL, Oeiras, Maro 2005                        */
/*                                                                      */
/* Acknowledgment: financial support from Fundacao para a Ciencia e a   */
/*                 Tecnologia, Portugal (grant SFRH/BPD/9466/2002).     */
/*                                                                      */
/************************************************************************/

#include<stdio.h>
#include<string.h>

int findsubstr(char *str, char *substr) {

  char *aux;

  int lenstr, lensubstr, lasti;

  int i;

  lenstr = strlen(str);
  lensubstr = strlen(substr);

  if (lensubstr>lenstr) {

    printf("\n*** Error in function findsubstr: ***\nLength of substring larger than length of string!\n");

    return -1;
  }

  lasti = lenstr - lensubstr;

  for (i=0; i<=lasti; i++) {

    aux = &str[i];

    if (!(strncmp(aux, substr, lensubstr))) return i+1;

  }

  return 0;

}
