import numpy as np
import matplotlib.pyplot as plt

mindists = np.loadtxt('res_dists.xvg', comments=('@', '#'))
contacts = mindists[:,1:] <= 0.6
avg_contact_fraction = contacts.mean(axis=0)
plt.plot(np.arange(1, len(avg_contact_fraction) + 1), avg_contact_fraction)
plt.savefig('contact_fraction.pdf')

